<?php
/**
 * Import users from an htpasswd file to USVN
 *
 * @author Team USVN <contact@usvn.info>
 * @link http://www.usvn.info
 * @license http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt CeCILL V2
 * @copyright Copyright 2007, Team USVN
 * @since 0.5
 * @package admin
 * @subpackage user
 *
 * This software has been written at EPITECH <http://www.epitech.net>
 * EPITECH, European Institute of Technology, Paris - FRANCE -
 * This project has been realised as part of
 * end of studies project.
 *
 * $Id: ImportHtpasswdTest.php 1188 2007-10-06 12:03:17Z crivis_s $
 */

// Call USVN_ImportHtpasswdTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "USVN_ImportHtpasswdTest::main");
}

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

define('CONFIG_FILE', 'tests/config.ini');
require_once 'library/USVN/autoload.php';

/**
 * Test class for USVN_ImportHtpasswd.
 * Generated by PHPUnit_Util_Skeleton on 2007-04-03 at 09:22:11.
 */
class USVN_ImportHtpasswdTest extends USVN_Test_DB {
    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main() {
        require_once "PHPUnit/TextUI/TestRunner.php";

        $suite  = new PHPUnit_Framework_TestSuite("USVN_ImportHtpasswdTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

	public function tearDown() {
		unlink("tests/htpasswd");
		parent::tearDown();
	}

	public function test_validFile()
	{
		file_put_contents("tests/htpasswd", "noplay:lQeKGl9L6sH3M\nbibi:9bhJwNgJ00I6E\n");
		$import = new USVN_ImportHtpasswd("tests/htpasswd");
		$this->assertEquals(array("noplay" => "lQeKGl9L6sH3M", "bibi" => "9bhJwNgJ00I6E"), $import->getUserPasswordList());
		$userTable = new USVN_Db_Table_Users();
		$user = $userTable->fetchRow(array('users_login = ?' => "noplay"));
		$this->assertEquals("lQeKGl9L6sH3M", $user->password);
	}

	public function test_validFile2()
	{
		file_put_contents("tests/htpasswd", "noplay:lQeKGl9L6sH3M\nbibi:9bhJwNgJ00I6E");
		$import = new USVN_ImportHtpasswd("tests/htpasswd");
		$this->assertEquals(array("noplay" => "lQeKGl9L6sH3M", "bibi" => "9bhJwNgJ00I6E"), $import->getUserPasswordList());
	}

	public function test_emptyFile()
	{
		file_put_contents("tests/htpasswd", "");
		$import = new USVN_ImportHtpasswd("tests/htpasswd");
		$this->assertEquals(array(), $import->getUserPasswordList());
	}

	public function test_invalidFile()
	{
		file_put_contents("tests/htpasswd", "noplay\nbibi:9bhJwNgJ00I6E");
		try {
			$import = new USVN_ImportHtpasswd("tests/htpasswd");
		}
		catch (USVN_Exception $e) {
			return;
		}
		$this->fail("This test need to throw an exception.");
	}

	public function test_invalidFile2()
	{
		file_put_contents("tests/htpasswd", "noplay:f:f\nbibi:9bhJwNgJ00I6E");
		try {
			$import = new USVN_ImportHtpasswd("tests/htpasswd");
		}
		catch (USVN_Exception $e) {
			return;
		}
		$this->fail("This test need to throw an exception.");
	}

	public function test_invalidFile3()
	{
		file_put_contents("tests/htpasswd", "noplay:test\nnoplay:tutu\nbibi:9bhJwNgJ00I6E");
		try {
			$import = new USVN_ImportHtpasswd("tests/htpasswd");
		}
		catch (USVN_Exception $e) {
			return;
		}
		$this->fail("This test need to throw an exception.");
	}

	public function test_updateUser()
	{
		file_put_contents("tests/htpasswd", "noplay:lQeKGl9L6sH3M\nbibi:9bhJwNgJ00I6E");
		$import = new USVN_ImportHtpasswd("tests/htpasswd");
		file_put_contents("tests/htpasswd", "noplay:BD3ZmTBhHmWJs\nbibi:9bhJwNgJ00I6E\njames:hkjfhdjk");
		$import = new USVN_ImportHtpasswd("tests/htpasswd");
		$userTable = new USVN_Db_Table_Users();
		$user = $userTable->fetchRow(array('users_login = ?' => "james"));
		$this->assertNotNull($user);
		$user = $userTable->fetchRow(array('users_login = ?' => "bibi"));
		$this->assertNotNull($user);
		$this->assertEquals("9bhJwNgJ00I6E", $user->password);
		$user = $userTable->fetchRow(array('users_login = ?' => "noplay"));
		$this->assertNotNull($user);
		$this->assertEquals("BD3ZmTBhHmWJs", $user->password);
	}
}

// Call USVN_ImportHtpasswdTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == "USVN_ImportHtpasswdTest::main") {
    USVN_ImportHtpasswdTest::main();
}
?>
