<?php
/**
 *
 * @author Team USVN <contact@usvn.info>
 * @link http://www.usvn.info
 * @license http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt CeCILL V2
 * @copyright Copyright 2007, Team USVN
 * @since 0.7.2
 * @package USVN_Db
 * @subpackage Table
 *
 * This software has been written at EPITECH <http://www.epitech.net>
 * EPITECH, European Institute of Technology, Paris - FRANCE -
 * This project has been realised as part of
 * end of studies project.
 *
 * $Id: Users.php 400 2007-05-13 15:15:38Z billar_m $
 */

// Call USVN_Db_Table_GroupsToProjectsTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "USVN_Db_Table_GroupsToProjectsTest::main");
}

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

require_once 'library/USVN/autoload.php';

/**
 * Test class for USVN_Db_Table_GroupsToProjects.
 * Generated by PHPUnit_Util_Skeleton on 2007-04-03 at 09:22:11.
 */
class USVN_Db_Table_GroupsToProjectsTest extends USVN_Test_DB {
    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main() {
        require_once "PHPUnit/TextUI/TestRunner.php";

        $suite  = new PHPUnit_Framework_TestSuite("USVN_Db_Table_GroupsToProjectsTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    public function test_affectandremovegroup()
    {
		$table = new USVN_Db_Table_GroupsToProjects();
		$project = $this->createProject("project");
		$project2 = $this->createProject("project2");
		$this->assertEquals(0, count($table->findByProjectId($project->id)));
		$this->assertEquals(0, count($table->findByProjectId($project2->id)));
		$group1 = $this->createGroup("group1");
		$group2 = $this->createGroup("group2");
		$project->addGroup($group1);
		$project2->addGroup($group1);
		$project->addGroup($group2);
		$project2->addGroup($group2);
		$this->assertEquals(2, count($table->findByProjectId($project->id)));
		$this->assertEquals(2, count($table->findByProjectId($project2->id)));


		$table_files = new USVN_Db_Table_FilesRights();
    	$fileid = $table_files->insert(array(
    		'projects_id'		=> $project->id,
			'files_rights_path' => '/trunk'
		));
		$table_groupstofiles = new USVN_Db_Table_GroupsToFilesRights();
		$res = $table_groupstofiles->findByIdRightsAndIdGroup($fileid, $group1->id);
		$this->assertNull($res);
		$table_groupstofiles->insert(array('files_rights_id' 		  => $fileid,
										   'files_rights_is_readable' => true,
				 						   'files_rights_is_writable' => false,
			       	 					   'groups_id'	 			  => $group1->id));
		$res = $table_groupstofiles->findByIdRightsAndIdGroup($fileid, $group1->id);
		$this->assertEquals(true, (bool) $res->files_rights_is_readable);
		$this->assertEquals(false, (bool)$res->files_rights_is_writable);

    	$fileid2 = $table_files->insert(array(
    		'projects_id'		=> $project2->id,
			'files_rights_path' => '/trunk'
		));
		$table_groupstofiles = new USVN_Db_Table_GroupsToFilesRights();
		$res = $table_groupstofiles->findByIdRightsAndIdGroup($fileid2, $group2->id);
		$this->assertNull($res);
		$table_groupstofiles->insert(array('files_rights_id' 		  => $fileid2,
										   'files_rights_is_readable' => true,
				 						   'files_rights_is_writable' => false,
			       	 					   'groups_id'	 			  => $group1->id));
		$res = $table_groupstofiles->findByIdRightsAndIdGroup($fileid2, $group1->id);
		$this->assertEquals(true, (bool) $res->files_rights_is_readable);
		$this->assertEquals(false, (bool)$res->files_rights_is_writable);


		$project->deleteGroup($group1);
		$this->assertEquals(1, count($table->findByProjectId($project->id)));
		$this->assertEquals(2, count($table->findByProjectId($project2->id)));

		$res = $table_groupstofiles->findByIdRightsAndIdGroup($fileid2, $group1->id);
		$this->assertNotNull($res);
		$this->assertEquals(true, (bool) $res->files_rights_is_readable);
		$this->assertEquals(false, (bool)$res->files_rights_is_writable);
	}
}

// Call USVN_Db_Table_GroupsToProjectsTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == "USVN_Db_Table_GroupsToProjectsTest::main") {
    USVN_Db_Table_GroupsToProjectsTest::main();
}
