<?php
/**
 * Parse ouput of svn log command
 *
 * @author Team USVN <contact@usvn.info>
 * @link http://www.usvn.info
 * @license http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt CeCILL V2
 * @copyright Copyright 2007, Team USVN
 * @since 0.6.4
 * @package client
 * @subpackage utils
 *
 * This software has been written at EPITECH <http://www.epitech.net>
 * EPITECH, European Institute of Technology, Paris - FRANCE -
 * This project has been realised as part of
 * end of studies project.
 *
 * $Id: SVNLogTest.php 1298 2007-11-04 17:02:54Z duponc_j $
 */

// Call USVN_SVNLogTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "USVN_SVNLogTest::main");
}

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

require_once 'library/USVN/autoload.php';

/**
 * Test class for USVN_SVNUtils.
 * Generated by PHPUnit_Util_Skeleton on 2007-03-10 at 17:59:54.
 */
class USVN_SVNLogTest extends USVN_Test_Test {
	private $_saveHOME;

    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main() {
        require_once "PHPUnit/TextUI/TestRunner.php";

        $suite  = new PHPUnit_Framework_TestSuite("USVN_SVNLogTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    protected function setUp()
    {
		parent::setUp();
		mkdir('tests/fakehome');
		chmod('tests/fakehome', 0000);
		putenv('HOME=tests/fakehome');
		$this->_saveHOME = getenv("HOME");
		USVN_SVNUtils::createSvn('tests/tmp/svn directory');
		USVN_SVNUtils::createStandardDirectories('tests/tmp/svn directory');
        USVN_SVNUtils::checkoutSvn('tests/tmp/svn directory', 'tests/tmp/out');
		file_put_contents('tests/tmp/svn directory/hooks/pre-revprop-change.bat', "@ECHO OFF\r\n");
		file_put_contents('tests/tmp/svn directory/hooks/pre-revprop-change', "#!/bin/sh\nexit 0");
		chmod('tests/tmp/svn directory/hooks/pre-revprop-change', 0700);
        $path = getcwd();
        chdir('tests/tmp/out');
        mkdir('trunk/testdir');
        `svn add trunk/testdir`;
        touch('trunk/testfile');
        `svn add trunk/testfile`;
        `svn commit --non-interactive --username toto -m Test`;
        touch('trunk/testfile2');
        `svn add trunk/testfile2`;
        `svn commit --non-interactive --username tutu -m Test2`;
		`svn propset svn:date --revprop -r3 "1984-12-03T01:02:03.218987Z" .`;
        chdir($path);
    }

	protected function tearDown()
	{
		putenv('HOME=' . $this->_saveHOME);
		parent::tearDown();
	}

	public function test_log()
	{
		$res = USVN_SVNLog::log('tests/tmp/svn directory', 5);
		$this->assertEquals(count($res), 3);
		$rev3 = $res[3];
		$rev1 = $res[1];
		$this->assertEquals('USVN', $rev1['author']);
		$this->assertEquals('tutu', $rev3['author']);
		$this->assertEquals('Test2', $rev3['msg']);
		$this->assertEquals('1984', date('Y', $rev3['date']));
		$this->assertEquals('12', date('m', $rev3['date']));
		$this->assertEquals('03', date('d', $rev3['date']));
		$this->assertEquals('01', date('H', $rev3['date']));
		$this->assertEquals('02', date('i', $rev3['date']));
		$this->assertEquals('03', date('s', $rev3['date']));
	}

	public function test_limit()
	{
		$res = USVN_SVNLog::log('tests/tmp/svn directory', 1);
		$this->assertEquals(count($res), 1);
		$this->assertFalse(isset($res[1]));
		$rev3 = $res[3];
		$this->assertEquals('tutu', $rev3['author']);
		$this->assertEquals('Test2', $rev3['msg']);
		$this->assertEquals('1984', date('Y', $rev3['date']));
		$this->assertEquals('12', date('m', $rev3['date']));
		$this->assertEquals('03', date('d', $rev3['date']));
		$this->assertEquals('01', date('H', $rev3['date']));
		$this->assertEquals('02', date('i', $rev3['date']));
		$this->assertEquals('03', date('s', $rev3['date']));
	}

	public function test_nolimit()
	{
		$res = USVN_SVNLog::log('tests/tmp/svn directory', 0);
		$this->assertEquals(count($res), 3);
		$rev3 = $res[3];
		$rev1 = $res[1];
		$this->assertEquals('USVN', $rev1['author']);
		$this->assertEquals('tutu', $rev3['author']);
		$this->assertEquals('Test2', $rev3['msg']);
		$this->assertEquals('1984', date('Y', $rev3['date']));
		$this->assertEquals('12', date('m', $rev3['date']));
		$this->assertEquals('03', date('d', $rev3['date']));
		$this->assertEquals('01', date('H', $rev3['date']));
		$this->assertEquals('02', date('i', $rev3['date']));
		$this->assertEquals('03', date('s', $rev3['date']));
	}
}

// Call USVN_SVNLogTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == "USVN_SVNLogTest::main") {
    USVN_SVNLogTest::main();
}
?>
