<?php
/**
 * Class to manipulate config file
 *
 * @author Team USVN <contact@usvn.info>
 * @link http://www.usvn.info
 * @license http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt CeCILL V2
 * @copyright Copyright 2007, Team USVN
 * @since 0.5
 * @package usvn
 *
 * This software has been written at EPITECH <http://www.epitech.net>
 * EPITECH, European Institute of Technology, Paris - FRANCE -
 * This project has been realised as part of
 * end of studies project.
 *
 * $Id: DirectoryUtilsTest.php 1345 2007-11-17 08:53:56Z dolean_j $
 */

// Call USVN_DirectoryUtilsTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "USVN_DirectoryUtilsTest::main");
}

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

require_once 'library/USVN/autoload.php';

/**
 * Test class for USVN_DirectoryUtils.
 * Generated by PHPUnit_Util_Skeleton on 2007-03-10 at 16:12:51.
 */
class USVN_DirectoryUtilsTest extends USVN_Test_Test {
    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main() {
        require_once "PHPUnit/TextUI/TestRunner.php";

        $suite  = new PHPUnit_Framework_TestSuite("USVN_DirectoryUtilsTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

	public function test_removeDirectory()
	{
		@mkdir('tests/tmp/dir');
		@mkdir('tests/tmp/dir/1');
		@mkdir('tests/tmp/dir/2');
		@mkdir('tests/tmp/dir/2/3');
		file_put_contents('tests/tmp/dir/2/3/test', 'tutu');
		file_put_contents('tests/tmp/dir/test', 'tutu');
		USVN_DirectoryUtils::removeDirectory('tests/tmp/dir');
		$this->assertFalse(file_exists('tests/tmp/dir'));
	}

	public function test_removeDirectoryReadOnly()
	{
		@mkdir('tests/tmp/dir');
		@mkdir('tests/tmp/dir/1');
		@mkdir('tests/tmp/dir/2');
		@mkdir('tests/tmp/dir/2/3');
		file_put_contents('tests/tmp/dir/2/3/test', 'tutu');
		file_put_contents('tests/tmp/dir/test', 'tutu');
		@chmod('tests/tmp/dir', 0444);
		USVN_DirectoryUtils::removeDirectory('tests/tmp/dir');
		$this->assertFalse(file_exists('tests/tmp/dir'));
	}

	public function test_listDirectory()
	{
		@mkdir('tests/tmp/dir');
		@mkdir('tests/tmp/dir/1');
		@mkdir('tests/tmp/dir/2');
		@mkdir('tests/tmp/dir/3');
		$list = USVN_DirectoryUtils::listDirectory('tests/tmp/dir/');
		$this->assertTrue(in_array('1', $list));
		$this->assertTrue(in_array('2', $list));
		$this->assertTrue(in_array('3', $list));
		$this->assertFalse(in_array('..', $list));
		$this->assertFalse(in_array('.svn', $list));
		USVN_DirectoryUtils::removeDirectory('tests/tmp/dir');
	}

	public function test_getTmpDirectory()
	{
		$path = USVN_DirectoryUtils::getTmpDirectory();
		$this->assertTrue(touch($path. "/test"));
	}

	public function test_isRootDirectory()
	{
		if(strtoupper(substr(PHP_OS, 0,3)) == 'WIN' ) {
			$this->assertFalse(USVN_DirectoryUtils::isRootDirectory('C:\\home'));
			$this->assertTrue(USVN_DirectoryUtils::isRootDirectory('C:'));
			$this->assertTrue(USVN_DirectoryUtils::isRootDirectory('C:\\'));
		}
		else {
			$this->assertFalse(USVN_DirectoryUtils::isRootDirectory('/home'));
			$this->assertTrue(USVN_DirectoryUtils::isRootDirectory('/'));
		}
	}

	public function test_firstDirectoryIsInclude()
	{
	}
}

// Call USVN_DirectoryUtilsTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == "USVN_DirectoryUtilsTest::main") {
    USVN_DirectoryUtilsTest::main();
}
?>
