<?php
/**
 * Model for files_rights table
 * Extends USVN_Db_Table for magic configuration and methods
 *
 * @author Team USVN <contact@usvn.info>
 * @link http://www.usvn.info
 * @license http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt CeCILL V2
 * @copyright Copyright 2007, Team USVN
 * @since 0.5
 * @package USVN_Db
 * @subpackage Table
 *
 * This software has been written at EPITECH <http://www.epitech.net>
 * EPITECH, European Institute of Technology, Paris - FRANCE -
 * This project has been realised as part of
 * end of studies project.
 *
 * $Id: Users.php 400 2007-05-13 15:15:38Z billar_m $
 */

// Call USVN_Db_Table_FileRightsTest::main() if this source file is executed directly.
if (!defined("PHPUnit_MAIN_METHOD")) {
    define("PHPUnit_MAIN_METHOD", "USVN_Db_Table_FileRightsTest::main");
}

require_once "PHPUnit/Framework/TestCase.php";
require_once "PHPUnit/Framework/TestSuite.php";

require_once 'library/USVN/autoload.php';

/**
 * Test class for USVN_Db_Table_FileRights.
 * Generated by PHPUnit_Util_Skeleton on 2007-04-03 at 09:22:11.
 */
class USVN_Db_Table_FileRightsTest extends USVN_Test_DB {
	private $_projectid1;
	private $_projectid2;

    /**
     * Runs the test methods of this class.
     *
     * @access public
     * @static
     */
    public static function main() {
        require_once "PHPUnit/TextUI/TestRunner.php";

        $suite  = new PHPUnit_Framework_TestSuite("USVN_Db_Table_FileRightsTest");
        $result = PHPUnit_TextUI_TestRunner::run($suite);
    }

    public function setUp()
    {
    	parent::setUp();

		$table = new USVN_Db_Table_Projects();
		$project = $table->fetchNew();
		$project->setFromArray(array('projects_name' => 'project1',  'projects_start_date' => '1984-12-03 00:00:00'));
		$this->_projectid1 = $project->save();

		$table = new USVN_Db_Table_Projects();
		$project = $table->fetchNew();
		$project->setFromArray(array('projects_name' => 'project2',  'projects_start_date' => '1984-12-03 00:00:00'));
		$this->_projectid2 = $project->save();

		$table_files = new USVN_Db_Table_FilesRights();
    	$id = $table_files->insert(array(
    		'projects_id'		=> $this->_projectid1,
			'files_rights_path' => '/'
		));
	}

    public function test_findByPath()
    {
    	$file_rights = new USVN_Db_Table_FilesRights();
    	$this->assertType('USVN_Db_Table_Row', $file_rights->findByPath($this->_projectid1, "/"));
    	$this->assertNull($file_rights->findByPath($this->_projectid1, "/trunk"));

		$table_files = new USVN_Db_Table_FilesRights();
    	$id = $table_files->insert(array(
    		'projects_id'		=> $this->_projectid1,
			'files_rights_path' => '/trunk'
		));
    	$this->assertType('USVN_Db_Table_Row', $file_rights->findByPath($this->_projectid1, "/trunk"));
    	$this->assertType('USVN_Db_Table_Row', $file_rights->findByPath($this->_projectid1, "/trunk/"));
    	$this->assertNull($file_rights->findByPath($this->_projectid2, "/trunk"));
    }
}

// Call USVN_Db_Table_FileRightsTest::main() if this source file is executed directly.
if (PHPUnit_MAIN_METHOD == "USVN_Db_Table_FileRightsTest::main") {
    USVN_Db_Table_FileRightsTest::main();
}
